---
title: "Concepts de base de Docker"
course: "docker"
slug: "2-concepts-de-base-de-docker"
order: 2
createdAt: 2025-09-24
updatedAt: 2025-09-24
---

Pour bien comprendre Docker, il est essentiel de maîtriser quelques concepts fondamentaux :

---

## Image Docker

Une **image** est un modèle en lecture seule utilisé pour créer un conteneur. Elle contient tout ce qu'il faut pour faire tourner une application : code source, bibliothèques, dépendances, fichiers de configuration, etc.

> [!info] Analogie
> Une image est comme une photo figée d'un système à un instant donné.

**Exemple concret :** Une image de Node.js contient :

- Node.js installé
- Le code de ton app
- Les fichiers package.json, etc.

On peut créer ses propres images ou utiliser celles du **Docker Hub**, une immense bibliothèque publique d'images prêtes à l'emploi.

---

## Conteneur

Un **conteneur** est une instance en cours d'exécution d'une image. C'est un processus isolé qui s'exécute sur ton système, basé sur une image.

> [!info] Analogie
> Une image est le plan, le conteneur est la maison construite à partir de ce plan.

**Caractéristiques d'un conteneur :**

- **Isolé** des autres (réseau, système de fichiers, etc.)
- **Éphémère** (il peut être détruit et reconstruit facilement)
- **Léger** et rapide à démarrer

---

## Dockerfile

Un **Dockerfile** est un fichier texte qui décrit étape par étape comment construire une image. Il contient des instructions comme :

```dockerfile
FROM python:3.12
COPY . /app
WORKDIR /app
RUN pip install -r requirements.txt
CMD ["python", "main.py"]
```

> [!tip] Point clé
> Le Dockerfile est un script pour construire ton image de manière reproductible.

---

## Volumes

Un **volume** est une solution pour persister des données en dehors du cycle de vie d'un conteneur. Sans volume, si tu supprimes un conteneur, tu perds toutes ses données.

**Il existe deux types de volumes :**

|Type|Description|
|---|---|
|**Bind mount**|Lie un dossier local à l'intérieur du conteneur|
|**Named volume**|Géré par Docker, plus flexible et isolé|

> [!warning] Important
> Les données dans un conteneur sans volume disparaissent à sa suppression !

---

## Réseaux Docker

Docker crée des **réseaux virtuels** pour que les conteneurs puissent communiquer entre eux, ou avec l'extérieur.

**Types de réseaux les plus courants :**

- **bridge** (par défaut, pour communication entre conteneurs sur la même machine)
- **host** (le conteneur partage le réseau de l'hôte)
- **none** (aucune connexion réseau)

> [!tip] Astuce
> Avec Docker Compose, les services peuvent facilement communiquer via des noms de conteneurs (web, db, etc.)

---

## Liens vers la partie suivante

- [[3. Installation de Docker]]

---

## Tags

#docker #concepts #images #conteneurs #volumes #réseaux #dockerfile